local Ponies = require 'PI_PonyVariations'

Ponies.wantedPonies = {}


---Replaces an item in a container with a random item from the item list.
---@param container ItemContainer
local function replaceDummies(container)
    local dummies = container:getAllType("PompsItems_MyLittlePony.PIDummyPony") -- dummy item type
    for i = 0, dummies:size()-1 do
        container:Remove(dummies:get(i))
        local itemChoice = ZombRand(#Ponies.wantedPonies)+1
        local item = container:AddItem(Ponies.wantedPonies[itemChoice])
        container:addItemOnServer(item)
    end
end

-- for items in containers
local function onFillContainer(_roomName, _containerType, container)
	--for some reason, the container object passed is sometimes not actually a container object
	--this is a quick and simple way to check (even if tostring maybe isnt the most optimal to call so often)
	if tostring(container):sub(1, 13) ~= "ItemContainer" then return end;
    replaceDummies(container);
end

Events.OnFillContainer.Add(onFillContainer)


-- for items found on zombies
local function onRefreshInventoryWindowContainers(inventoryPage)
    if not inventoryPage.inventory or not instanceof(inventoryPage.inventory:getParent(), "IsoDeadBody") then return end
	--print("WindowContainerUpdate: ", inventoryPage.inventory);
    replaceDummies(inventoryPage.inventory)
end


Events.OnRefreshInventoryWindowContainers.Add(onRefreshInventoryWindowContainers)


function SetPonyDistributionData()
	print("-----------PonyMLPPlushieDistribution----------")
	-- Define a table to store the distribution data
	local PonyDistributionData = {
		{ location = "GigamartToys", weight = 15.0 },
		{ location = "WardrobeChild", weight = 8.64 },
		{ location = "WardrobeGeneric", weight = 0.7 },
		{ location = "DaycareCounter", weight = 4.6 },
		{ location = "DaycareShelves", weight = 4.6 },
		{ location = "CrateToys", weight = 20.0 },
		{ location = "BedroomDresserChild", weight = 4.0 },
		{ location = "BedroomSidetableChild", weight = 2.5 },
		{ location = "BedroomSidetable", weight = 0.4 },
		{ location = "Gifts", weight = 17.0 },
		{ location = "GiftStoreToys", weight = 18.0 },
		{ location = "Hobbies", weight = 12.0 },
		{ location = "CarnivalPrizes", weight = 20.0 },
		{ location = "DresserGeneric", weight = 0.25 },
		{ location = "StripClubDressers", weight = 0.3 },
	}

	-- Loop through the data and insert items
	for _, data in ipairs(PonyDistributionData) do
		if ProceduralDistributions["list"][data.location] then
			local list = ProceduralDistributions["list"][data.location].items
			table.insert(list, "PompsItems_MyLittlePony.PIDummyPony")
			table.insert(list, data.weight * SandboxVars.PompsItems.PonySpawnRate)
		else
			print("Warning: No items list found for location " .. data.location)
		end
	end
	
		
	local PonyZombieDistributionData = {
		{ location = "inventorymale", weight = 3.8 },
		{ location = "inventoryfemale", weight = 3.8 },
	}

	for _, data in ipairs(PonyZombieDistributionData) do
		if SuburbsDistributions["all"][data.location] then
			local list = SuburbsDistributions["all"][data.location].items
			table.insert(list, "PompsItems_MyLittlePony.PIDummyPony")
			table.insert(list, data.weight * SandboxVars.PompsItems.PonyZombieSpawnRate)
		else
			print("Warning: No items list found for location " .. data.location)
		end
	end
	
	--idk what this is, i saw another mod do it.
	ItemPickerJava.Parse()
end


---Returns a numerically indexed table that is the combination of the two input tables.
---@param a table
---@param b table
---@return table
local function MergeTables(a, b)
    if not a then return b elseif not b then return a end
    local result = {}
    for _,v in pairs(a) do
        table.insert(result, v)
    end
    for _,v in pairs(b) do
        table.insert(result, v)
    end
    return result
end

function Ponies.createSpawnList()
    if SandboxVars.PompsItems.AlbionSpawnlist then
        return Ponies.albionSpawnlist
    end
 
   
    local wantedPonies
    if SandboxVars.PompsItems.WantMane6Ponies then
        wantedPonies = Ponies.mane6Ponies
    end

    if SandboxVars.PompsItems.WantG4Ponies then
        wantedPonies = Ponies.gen4Ponies
    end

    if SandboxVars.PompsItems.WantG5Ponies then
        wantedPonies = MergeTables(wantedPonies, Ponies.g5Ponies)
    end

    if SandboxVars.PompsItems.WantClassicPonies then
        wantedPonies = MergeTables(wantedPonies, Ponies.classicPonies)
    end

    if SandboxVars.PompsItems.WantOCs then
        wantedPonies = MergeTables(wantedPonies, Ponies.ocs)
    end
	
    if SandboxVars.PompsItems.WantFoE then
        wantedPonies = MergeTables(wantedPonies, Ponies.falloutequestria)
    end
	
    if SandboxVars.PompsItems.WantCons then
        wantedPonies = MergeTables(wantedPonies, Ponies.cons)
    end

    if SandboxVars.PompsItems.WantMLPFNAF then
        wantedPonies = MergeTables(wantedPonies, Ponies.fnaf)
    end

    if SandboxVars.PompsItems.WantSpacePonyos then
        wantedPonies = MergeTables(wantedPonies, Ponies.spaceponyos)
    end
	
    if SandboxVars.PompsItems.WantEmpyreanPones then
        wantedPonies = MergeTables(wantedPonies, Ponies.empyrean)
    end

    if SandboxVars.PompsItems.WantNeetPones then
        wantedPonies = MergeTables(wantedPonies, Ponies.neet)
    end

    if SandboxVars.PompsItems.WantPopularPones then
        wantedPonies = MergeTables(wantedPonies, Ponies.popular)
    end

    return wantedPonies
end

Events.OnInitGlobalModData.Add(function()
    Ponies.wantedPonies = Ponies.createSpawnList()
	SetPonyDistributionData();
end)


return Ponies