require 'Items/SuburbsDistributions'
require 'Items/ProceduralDistributions'

LootRarity = {}
LootRarity.Common = 15
LootRarity.Uncommon = 8
LootRarity.Rare = 2
LootRarity.VeryRare = 0.5
LootRarity.ExtraRare = 0.01

local suburbsDistribution = {
    all = {
        inventoryfemale = {
            items = {
                "iMeds.BismuthSubsalicylatePack", LootRarity.ExtraRare,
                "iMeds.AlkaginPack", LootRarity.ExtraRare,
                "iMeds.UmifenovirPack", LootRarity.ExtraRare,
                "iMeds.UnknownPack", LootRarity.ExtraRare,
                "iMeds.ButamiratePack", LootRarity.ExtraRare,
                "iMeds.HemoStopPack", LootRarity.ExtraRare,
                "iMeds.SyringePack", LootRarity.ExtraRare,
                "iMeds.NeedlePack", LootRarity.ExtraRare,
                "iMeds.BloodTestingKit", LootRarity.ExtraRare,
                "iMeds.NasivionPack", LootRarity.ExtraRare,
                "iMeds.ErythropoietinPack", LootRarity.ExtraRare,
                "Base.BloodPressureMonitorLeft", LootRarity.ExtraRare,
                "Base.HeartRateMonitorLeft", LootRarity.ExtraRare,
            }
        },
        inventorymale = {
            items = {
                "iMeds.HemoStopPack", LootRarity.ExtraRare,
                "iMeds.BismuthSubsalicylatePack", LootRarity.ExtraRare,
                "iMeds.AlkaginPack", LootRarity.ExtraRare,
                "iMeds.UmifenovirPack", LootRarity.ExtraRare,
                "iMeds.UnknownPack", LootRarity.ExtraRare,
                "iMeds.ButamiratePack", LootRarity.ExtraRare,
                "iMeds.HemoStopPack", LootRarity.ExtraRare,
                "iMeds.SyringePack", LootRarity.ExtraRare,
                "iMeds.NeedlePack", LootRarity.ExtraRare,
                "iMeds.BloodTestingKit", LootRarity.ExtraRare,
                "iMeds.NasivionPack", LootRarity.ExtraRare,
                "iMeds.ErythropoietinPack", LootRarity.ExtraRare,
                "Base.BloodPressureMonitorLeft", LootRarity.ExtraRare,
                "Base.HeartRateMonitorLeft", LootRarity.ExtraRare,
            }
        },
        medicine = {
            items = {
                "iMeds.BismuthSubsalicylatePack", LootRarity.VeryRare,
                "iMeds.AlkaginPack", LootRarity.VeryRare,
                "iMeds.UmifenovirPack", LootRarity.VeryRare,
                "iMeds.MorphinePack", LootRarity.VeryRare,
                "iMeds.UnknownPack", LootRarity.Uncommon,
                "iMeds.ButamiratePack", LootRarity.VeryRare,
                "iMeds.BismuthSubsalicylatePack", LootRarity.VeryRare,
                "iMeds.HemoStopPack", LootRarity.VeryRare,
                "iMeds.PeripheralVenousCatheter", LootRarity.Rare,
                "iMeds.EmptyBloodBag", LootRarity.Rare,
                "iMeds.BloodTestingKit", LootRarity.Uncommon,
                "iMeds.NasivionPack", LootRarity.VeryRare,
                "iMeds.ErythropoietinPack", LootRarity.VeryRare,
                "Base.BloodPressureMonitorLeft", LootRarity.ExtraRare,
                "Base.HeartRateMonitorLeft", LootRarity.ExtraRare,
            },
        },
    },

    Bag_BigHikingBag = {
        items = {
            "iMeds.BismuthSubsalicylatePack", LootRarity.VeryRare,
            "iMeds.AlkaginPack", LootRarity.VeryRare,
            "iMeds.UmifenovirPack", LootRarity.VeryRare,
            "iMeds.UnknownPack", LootRarity.VeryRare,
            "iMeds.ButamiratePack", LootRarity.VeryRare,
            "iMeds.BismuthSubsalicylatePack", LootRarity.VeryRare,
            "iMeds.HemoStopPack", LootRarity.VeryRare,
            "iMeds.SyringePack", LootRarity.VeryRare,
            "iMeds.NeedlePack", LootRarity.VeryRare,
            "iMeds.NasivionPack", LootRarity.VeryRare,
            "iMeds.ErythropoietinPack", LootRarity.VeryRare,
            "Base.BloodPressureMonitorLeft", LootRarity.ExtraRare,
            "Base.HeartRateMonitorLeft", LootRarity.ExtraRare,
        },
    },

    Bag_NormalHikingBag = {
        items = {
            "iMeds.BismuthSubsalicylatePack", LootRarity.VeryRare,
            "iMeds.AlkaginPack", LootRarity.VeryRare,
            "iMeds.UmifenovirPack", LootRarity.VeryRare,
            "iMeds.UnknownPack", LootRarity.VeryRare,
            "iMeds.ButamiratePack", LootRarity.VeryRare,
            "iMeds.BismuthSubsalicylatePack", LootRarity.VeryRare,
            "iMeds.HemoStopPack", LootRarity.VeryRare,
            "iMeds.SyringePack", LootRarity.VeryRare,
            "iMeds.NeedlePack", LootRarity.VeryRare,
            "iMeds.NasivionPack", LootRarity.VeryRare,
            "iMeds.ErythropoietinPack", LootRarity.VeryRare,
            "Base.BloodPressureMonitorLeft", LootRarity.ExtraRare,
            "Base.HeartRateMonitorLeft", LootRarity.ExtraRare,
        },
    },

    Bag_SurvivorBag = {
        items = {
            "iMeds.BismuthSubsalicylatePack", LootRarity.VeryRare,
            "iMeds.AlkaginPack", LootRarity.VeryRare,
            "iMeds.UmifenovirPack", LootRarity.VeryRare,
            "iMeds.UnknownPack", LootRarity.VeryRare,
            "iMeds.ButamiratePack", LootRarity.VeryRare,
            "iMeds.BismuthSubsalicylatePack", LootRarity.VeryRare,
            "iMeds.HemoStopPack", LootRarity.VeryRare,
            "iMeds.PeripheralVenousCatheter", LootRarity.VeryRare,
            "iMeds.EmptyBloodBag", LootRarity.VeryRare,
            "iMeds.BloodTestingKit", LootRarity.VeryRare,
            "iMeds.SyringePack", LootRarity.VeryRare,
            "iMeds.NeedlePack", LootRarity.VeryRare,
            "iMeds.NasivionPack", LootRarity.VeryRare,
            "iMeds.ErythropoietinPack", LootRarity.VeryRare,
            "Base.BloodPressureMonitorLeft", LootRarity.ExtraRare,
            "Base.HeartRateMonitorLeft", LootRarity.ExtraRare,
        },
    },

    FirstAidKit = {
        items = {
            "iMeds.UnknownPack", LootRarity.VeryRare,
            "iMeds.UnknownPack", LootRarity.VeryRare,
            "iMeds.UnknownPack", LootRarity.VeryRare,
            "iMeds.ButamiratePack", LootRarity.VeryRare,
            "iMeds.BismuthSubsalicylatePack", LootRarity.VeryRare,
            "iMeds.HemoStopPack", LootRarity.VeryRare,
            "iMeds.PeripheralVenousCatheter", LootRarity.VeryRare,
            "iMeds.PeripheralVenousCatheter", LootRarity.VeryRare,
            "iMeds.PeripheralVenousCatheter", LootRarity.VeryRare,
            "iMeds.PeripheralVenousCatheter", LootRarity.VeryRare,
            "iMeds.AlkaginPack", LootRarity.VeryRare,
            "iMeds.AlkaginPack", LootRarity.VeryRare,
            "iMeds.UmifenovirPack", LootRarity.VeryRare,
            "iMeds.BloodTestingKit", LootRarity.VeryRare,
            "iMeds.BloodTestingKit", LootRarity.VeryRare,
            "iMeds.BloodTestingKit", LootRarity.VeryRare,
            "iMeds.BloodTestingKit", LootRarity.VeryRare,
            "iMeds.SyringePack", LootRarity.Rare,
            "iMeds.SyringePack", LootRarity.Rare,
            "iMeds.NeedlePack", LootRarity.Rare,
            "iMeds.NeedlePack", LootRarity.Rare,
            "iMeds.NasivionPack", LootRarity.Rare,
            "iMeds.ErythropoietinPack", LootRarity.Rare,
            "Base.BloodPressureMonitorLeft", LootRarity.ExtraRare,
        },
    },
}

local proceduralDistributions = {
    list = {
        ArmyStorageMedical = {
            items = {
                "iMeds.BismuthSubsalicylatePack", LootRarity.Uncommon,
                "iMeds.BismuthSubsalicylatePack", LootRarity.Uncommon,
                "iMeds.BismuthSubsalicylatePack", LootRarity.Uncommon,
                "iMeds.BismuthSubsalicylatePack", LootRarity.Uncommon,

                "iMeds.AlkaginPack", LootRarity.Uncommon,
                "iMeds.AlkaginPack", LootRarity.Uncommon,
                "iMeds.AlkaginPack", LootRarity.Uncommon,
                "iMeds.AlkaginPack", LootRarity.Uncommon,

                "iMeds.UmifenovirPack", LootRarity.Uncommon,
                "iMeds.UmifenovirPack", LootRarity.Uncommon,
                "iMeds.UmifenovirPack", LootRarity.Uncommon,
                "iMeds.UmifenovirPack", LootRarity.Uncommon,

                "iMeds.MorphinePack", LootRarity.Rare,
                "iMeds.MorphinePack", LootRarity.Rare,
                "iMeds.MorphinePack", LootRarity.Rare,
                "iMeds.MorphinePack", LootRarity.Rare,

                "iMeds.UnknownPack", LootRarity.Rare,
                "iMeds.UnknownPack", LootRarity.Rare,
                "iMeds.UnknownPack", LootRarity.Rare,
                "iMeds.UnknownPack", LootRarity.Rare,

                "iMeds.ButamiratePack", LootRarity.Uncommon,
                "iMeds.ButamiratePack", LootRarity.Uncommon,
                "iMeds.ButamiratePack", LootRarity.Uncommon,
                "iMeds.ButamiratePack", LootRarity.Uncommon,

                "iMeds.BismuthSubsalicylatePack", LootRarity.Uncommon,
                "iMeds.BismuthSubsalicylatePack", LootRarity.Uncommon,
                "iMeds.BismuthSubsalicylatePack", LootRarity.Uncommon,
                "iMeds.BismuthSubsalicylatePack", LootRarity.Uncommon,

                "iMeds.HemoStopPack", LootRarity.Rare,
                "iMeds.HemoStopPack", LootRarity.Rare,
                "iMeds.HemoStopPack", LootRarity.Rare,
                "iMeds.HemoStopPack", LootRarity.Rare,

                "iMeds.PeripheralVenousCatheter", LootRarity.Rare,
                "iMeds.PeripheralVenousCatheter", LootRarity.Rare,
                "iMeds.PeripheralVenousCatheter", LootRarity.Rare,
                "iMeds.PeripheralVenousCatheter", LootRarity.Rare,

                "iMeds.EmptyBloodBag", LootRarity.Rare,
                "iMeds.EmptyBloodBag", LootRarity.Rare,
                "iMeds.EmptyBloodBag", LootRarity.Rare,
                "iMeds.EmptyBloodBag", LootRarity.Rare,

                "iMeds.BloodTestingKit", LootRarity.Uncommon,
                "iMeds.BloodTestingKit", LootRarity.Uncommon,
                "iMeds.BloodTestingKit", LootRarity.Uncommon,
                "iMeds.BloodTestingKit", LootRarity.Uncommon,

                "iMeds.SyringePack", LootRarity.Uncommon,
                "iMeds.SyringePack", LootRarity.Uncommon,
                "iMeds.SyringePack", LootRarity.Uncommon,
                "iMeds.SyringePack", LootRarity.Uncommon,

                "iMeds.NeedlePack", LootRarity.Uncommon,
                "iMeds.NeedlePack", LootRarity.Uncommon,
                "iMeds.NeedlePack", LootRarity.Uncommon,
                "iMeds.NeedlePack", LootRarity.Uncommon,

                "iMeds.ErythrocyteSuspensionBagABN", LootRarity.Rare,
                "iMeds.ErythrocyteSuspensionBagABN", LootRarity.Rare,
                "iMeds.ErythrocyteSuspensionBagABN", LootRarity.Rare,
                "iMeds.ErythrocyteSuspensionBagABP", LootRarity.Rare,
                "iMeds.ErythrocyteSuspensionBagABP", LootRarity.Rare,
                "iMeds.ErythrocyteSuspensionBagABP", LootRarity.Rare,
                "iMeds.ErythrocyteSuspensionBagAN", LootRarity.Rare,
                "iMeds.ErythrocyteSuspensionBagAN", LootRarity.Rare,
                "iMeds.ErythrocyteSuspensionBagAN", LootRarity.Rare,
                "iMeds.ErythrocyteSuspensionBagAP", LootRarity.Rare,
                "iMeds.ErythrocyteSuspensionBagAP", LootRarity.Rare,
                "iMeds.ErythrocyteSuspensionBagAP", LootRarity.Rare,
                "iMeds.ErythrocyteSuspensionBagBN", LootRarity.Rare,
                "iMeds.ErythrocyteSuspensionBagBN", LootRarity.Rare,
                "iMeds.ErythrocyteSuspensionBagBN", LootRarity.Rare,
                "iMeds.ErythrocyteSuspensionBagBP", LootRarity.Rare,
                "iMeds.ErythrocyteSuspensionBagBP", LootRarity.Rare,
                "iMeds.ErythrocyteSuspensionBagBP", LootRarity.Rare,
                "iMeds.ErythrocyteSuspensionBagON", LootRarity.Rare,
                "iMeds.ErythrocyteSuspensionBagON", LootRarity.Rare,
                "iMeds.ErythrocyteSuspensionBagON", LootRarity.Rare,
                "iMeds.ErythrocyteSuspensionBagOP", LootRarity.Rare,
                "iMeds.ErythrocyteSuspensionBagOP", LootRarity.Rare,
                "iMeds.ErythrocyteSuspensionBagOP", LootRarity.Rare,

                "iMeds.PlasmaBagABN", LootRarity.Rare,
                "iMeds.PlasmaBagABN", LootRarity.Rare,
                "iMeds.PlasmaBagABN", LootRarity.Rare,
                "iMeds.PlasmaBagABP", LootRarity.Rare,
                "iMeds.PlasmaBagABP", LootRarity.Rare,
                "iMeds.PlasmaBagABP", LootRarity.Rare,
                "iMeds.PlasmaBagAN", LootRarity.Rare,
                "iMeds.PlasmaBagAN", LootRarity.Rare,
                "iMeds.PlasmaBagAN", LootRarity.Rare,
                "iMeds.PlasmaBagAP", LootRarity.Rare,
                "iMeds.PlasmaBagAP", LootRarity.Rare,
                "iMeds.PlasmaBagAP", LootRarity.Rare,
                "iMeds.PlasmaBagBN", LootRarity.Rare,
                "iMeds.PlasmaBagBN", LootRarity.Rare,
                "iMeds.PlasmaBagBN", LootRarity.Rare,
                "iMeds.PlasmaBagBP", LootRarity.Rare,
                "iMeds.PlasmaBagBP", LootRarity.Rare,
                "iMeds.PlasmaBagBP", LootRarity.Rare,
                "iMeds.PlasmaBagON", LootRarity.Rare,
                "iMeds.PlasmaBagON", LootRarity.Rare,
                "iMeds.PlasmaBagON", LootRarity.Rare,
                "iMeds.PlasmaBagOP", LootRarity.Rare,
                "iMeds.PlasmaBagOP", LootRarity.Rare,
                "iMeds.PlasmaBagOP", LootRarity.Rare,

                "iMeds.NasivionPack", LootRarity.Uncommon,
                "iMeds.NasivionPack", LootRarity.Uncommon,
                "iMeds.NasivionPack", LootRarity.Uncommon,
                "iMeds.NasivionPack", LootRarity.Uncommon,

                "iMeds.ErythropoietinPack", LootRarity.Rare,
                "iMeds.ErythropoietinPack", LootRarity.Rare,
                "iMeds.ErythropoietinPack", LootRarity.Rare,
                "iMeds.ErythropoietinPack", LootRarity.Rare,

                "Base.BloodPressureMonitorLeft", LootRarity.ExtraRare,
                "Base.BloodPressureMonitorLeft", LootRarity.ExtraRare,
                "Base.BloodPressureMonitorLeft", LootRarity.ExtraRare,
                "Base.BloodPressureMonitorLeft", LootRarity.ExtraRare,

                "Base.HeartRateMonitorLeft", LootRarity.ExtraRare,
                "Base.HeartRateMonitorLeft", LootRarity.ExtraRare,
                "Base.HeartRateMonitorLeft", LootRarity.ExtraRare,
                "Base.HeartRateMonitorLeft", LootRarity.ExtraRare,
            },
        },

        BathroomCounterNoMeds = {
            items = {
                "iMeds.UnknownPack", LootRarity.VeryRare,
                "iMeds.UnknownPack", LootRarity.VeryRare,
                "iMeds.SyringePack", LootRarity.Rare,
                "iMeds.NeedlePack", LootRarity.Rare,
                "Base.BloodPressureMonitorLeft", LootRarity.ExtraRare,
            },
        },

        MedicalClinicDrugs = {
            items = {
                "iMeds.BismuthSubsalicylatePack", LootRarity.Uncommon,
                "iMeds.BismuthSubsalicylatePack", LootRarity.Uncommon,
                "iMeds.BismuthSubsalicylatePack", LootRarity.Uncommon,
                "iMeds.BismuthSubsalicylatePack", LootRarity.Uncommon,
                "iMeds.AlkaginPack", LootRarity.Uncommon,
                "iMeds.AlkaginPack", LootRarity.Uncommon,
                "iMeds.AlkaginPack", LootRarity.Uncommon,
                "iMeds.AlkaginPack", LootRarity.Uncommon,
                "iMeds.UmifenovirPack", LootRarity.Uncommon,
                "iMeds.UmifenovirPack", LootRarity.Uncommon,
                "iMeds.UmifenovirPack", LootRarity.Uncommon,
                "iMeds.UmifenovirPack", LootRarity.Uncommon,
                "iMeds.MorphinePack", LootRarity.Uncommon,
                "iMeds.MorphinePack", LootRarity.Uncommon,
                "iMeds.UnknownPack", LootRarity.Uncommon,
                "iMeds.UnknownPack", LootRarity.Uncommon,
                "iMeds.UnknownPack", LootRarity.Uncommon,
                "iMeds.ButamiratePack", LootRarity.Uncommon,
                "iMeds.ButamiratePack", LootRarity.Uncommon,
                "iMeds.ButamiratePack", LootRarity.Uncommon,
                "iMeds.ButamiratePack", LootRarity.Uncommon,
                "iMeds.BismuthSubsalicylatePack", LootRarity.Uncommon,
                "iMeds.BismuthSubsalicylatePack", LootRarity.Uncommon,
                "iMeds.BismuthSubsalicylatePack", LootRarity.Uncommon,
                "iMeds.BismuthSubsalicylatePack", LootRarity.Uncommon,
                "iMeds.HemoStopPack", LootRarity.Uncommon,
                "iMeds.HemoStopPack", LootRarity.Uncommon,
                "iMeds.HemoStopPack", LootRarity.Uncommon,
                "iMeds.PeripheralVenousCatheter", LootRarity.Uncommon,
                "iMeds.PeripheralVenousCatheter", LootRarity.Uncommon,
                "iMeds.PeripheralVenousCatheter", LootRarity.Uncommon,
                "iMeds.PeripheralVenousCatheter", LootRarity.Uncommon,
                "iMeds.EmptyBloodBag", LootRarity.Uncommon,
                "iMeds.EmptyBloodBag", LootRarity.Uncommon,
                "iMeds.EmptyBloodBag", LootRarity.Uncommon,
                "iMeds.EmptyBloodBag", LootRarity.Uncommon,
                "iMeds.BloodTestingKit", LootRarity.Uncommon,
                "iMeds.BloodTestingKit", LootRarity.Uncommon,
                "iMeds.BloodTestingKit", LootRarity.Uncommon,
                "iMeds.BloodTestingKit", LootRarity.Uncommon,
                "iMeds.BloodTestingKit", LootRarity.Uncommon,
                "iMeds.SyringePack", LootRarity.Uncommon,
                "iMeds.SyringePack", LootRarity.Uncommon,
                "iMeds.SyringePack", LootRarity.Uncommon,
                "iMeds.SyringePack", LootRarity.Uncommon,
                "iMeds.NeedlePack", LootRarity.Uncommon,
                "iMeds.NeedlePack", LootRarity.Uncommon,
                "iMeds.NeedlePack", LootRarity.Uncommon,
                "iMeds.NeedlePack", LootRarity.Uncommon,
                "iMeds.NasivionPack", LootRarity.Uncommon,
                "iMeds.NasivionPack", LootRarity.Uncommon,
                "iMeds.NasivionPack", LootRarity.Uncommon,
                "iMeds.NasivionPack", LootRarity.Uncommon,
                "iMeds.ErythropoietinPack", LootRarity.Rare,
                "iMeds.ErythropoietinPack", LootRarity.Rare,
                "iMeds.ErythropoietinPack", LootRarity.Rare,
                "iMeds.ErythropoietinPack", LootRarity.Rare,
            },
        },

        MedicalClinicOutfit = {
            items = {
                "iMeds.UnknownPack", LootRarity.Uncommon,
                "iMeds.EmptyBloodBag", LootRarity.Rare,
                "iMeds.EmptyBloodBag", LootRarity.Rare,
                "iMeds.BloodTestingKit", LootRarity.Uncommon,
                "iMeds.BloodTestingKit", LootRarity.Uncommon,
                "iMeds.SyringePack", LootRarity.Uncommon,
                "iMeds.NeedlePack", LootRarity.Uncommon,
                "iMeds.NasivionPack", LootRarity.Uncommon,

                "Base.BloodPressureMonitorLeft", LootRarity.Uncommon,
                "Base.BloodPressureMonitorLeft", LootRarity.Rare,
                "Base.BloodPressureMonitorLeft", LootRarity.Rare,

                "Base.HeartRateMonitorLeft", LootRarity.ExtraRare,
                "Base.HeartRateMonitorLeft", LootRarity.ExtraRare,
            },
        },

        MedicalClinicTools = {
            items = {
                "iMeds.PeripheralVenousCatheter", LootRarity.Uncommon,
                "iMeds.PeripheralVenousCatheter", LootRarity.Uncommon,
                "iMeds.PeripheralVenousCatheter", LootRarity.Uncommon,
                "iMeds.PeripheralVenousCatheter", LootRarity.Uncommon,
                "iMeds.EmptyBloodBag", LootRarity.Uncommon,
                "iMeds.EmptyBloodBag", LootRarity.Uncommon,
                "iMeds.EmptyBloodBag", LootRarity.Uncommon,
                "iMeds.EmptyBloodBag", LootRarity.Uncommon,
                "iMeds.BloodTestingKit", LootRarity.Uncommon,
                "iMeds.BloodTestingKit", LootRarity.Uncommon,
                "iMeds.BloodTestingKit", LootRarity.Uncommon,
                "iMeds.BloodTestingKit", LootRarity.Uncommon,
                "iMeds.SyringePack", LootRarity.Uncommon,
                "iMeds.SyringePack", LootRarity.Uncommon,
                "iMeds.SyringePack", LootRarity.Uncommon,
                "iMeds.SyringePack", LootRarity.Uncommon,
                "iMeds.NeedlePack", LootRarity.Uncommon,
                "iMeds.NeedlePack", LootRarity.Uncommon,
                "iMeds.NeedlePack", LootRarity.Uncommon,
                "iMeds.NeedlePack", LootRarity.Uncommon,

                "Base.BloodPressureMonitorLeft", LootRarity.Uncommon,
                "Base.BloodPressureMonitorLeft", LootRarity.Uncommon,
                "Base.BloodPressureMonitorLeft", LootRarity.ExtraRare,
                "Base.BloodPressureMonitorLeft", LootRarity.ExtraRare,

                "Base.HeartRateMonitorLeft", LootRarity.ExtraRare,
                "Base.HeartRateMonitorLeft", LootRarity.ExtraRare,
            },
        },

        MedicalStorageDrugs = {
            items = {
                "iMeds.BismuthSubsalicylatePack", LootRarity.Uncommon,
                "iMeds.AlkaginPack", LootRarity.Uncommon,
                "iMeds.AlkaginPack", LootRarity.Uncommon,
                "iMeds.AlkaginPack", LootRarity.Uncommon,
                "iMeds.AlkaginPack", LootRarity.Uncommon,
                "iMeds.UmifenovirPack", LootRarity.Uncommon,
                "iMeds.UmifenovirPack", LootRarity.Uncommon,
                "iMeds.UmifenovirPack", LootRarity.Uncommon,
                "iMeds.UmifenovirPack", LootRarity.Uncommon,
                "iMeds.MorphinePack", LootRarity.Uncommon,
                "iMeds.MorphinePack", LootRarity.Uncommon,
                "iMeds.MorphinePack", LootRarity.Uncommon,
                "iMeds.UnknownPack", LootRarity.Uncommon,
                "iMeds.UnknownPack", LootRarity.Uncommon,
                "iMeds.UnknownPack", LootRarity.Uncommon,
                "iMeds.UnknownPack", LootRarity.Uncommon,
                "iMeds.ButamiratePack", LootRarity.Uncommon,
                "iMeds.ButamiratePack", LootRarity.Uncommon,
                "iMeds.ButamiratePack", LootRarity.Uncommon,
                "iMeds.ButamiratePack", LootRarity.Uncommon,
                "iMeds.BismuthSubsalicylatePack", LootRarity.Uncommon,
                "iMeds.BismuthSubsalicylatePack", LootRarity.Uncommon,
                "iMeds.BismuthSubsalicylatePack", LootRarity.Uncommon,
                "iMeds.BismuthSubsalicylatePack", LootRarity.Uncommon,
                "iMeds.HemoStopPack", LootRarity.Uncommon,
                "iMeds.HemoStopPack", LootRarity.Uncommon,

                "iMeds.ErythrocyteSuspensionBagABN", LootRarity.Rare,
                "iMeds.ErythrocyteSuspensionBagABN", LootRarity.Rare,
                "iMeds.ErythrocyteSuspensionBagABN", LootRarity.Rare,
                "iMeds.ErythrocyteSuspensionBagABP", LootRarity.Rare,
                "iMeds.ErythrocyteSuspensionBagABP", LootRarity.Rare,
                "iMeds.ErythrocyteSuspensionBagABP", LootRarity.Rare,
                "iMeds.ErythrocyteSuspensionBagAN", LootRarity.Rare,
                "iMeds.ErythrocyteSuspensionBagAN", LootRarity.Rare,
                "iMeds.ErythrocyteSuspensionBagAN", LootRarity.Rare,
                "iMeds.ErythrocyteSuspensionBagAP", LootRarity.Rare,
                "iMeds.ErythrocyteSuspensionBagAP", LootRarity.Rare,
                "iMeds.ErythrocyteSuspensionBagAP", LootRarity.Rare,
                "iMeds.ErythrocyteSuspensionBagBN", LootRarity.Rare,
                "iMeds.ErythrocyteSuspensionBagBN", LootRarity.Rare,
                "iMeds.ErythrocyteSuspensionBagBN", LootRarity.Rare,
                "iMeds.ErythrocyteSuspensionBagBP", LootRarity.Rare,
                "iMeds.ErythrocyteSuspensionBagBP", LootRarity.Rare,
                "iMeds.ErythrocyteSuspensionBagBP", LootRarity.Rare,
                "iMeds.ErythrocyteSuspensionBagON", LootRarity.Rare,
                "iMeds.ErythrocyteSuspensionBagON", LootRarity.Rare,
                "iMeds.ErythrocyteSuspensionBagON", LootRarity.Rare,
                "iMeds.ErythrocyteSuspensionBagOP", LootRarity.Rare,
                "iMeds.ErythrocyteSuspensionBagOP", LootRarity.Rare,
                "iMeds.ErythrocyteSuspensionBagOP", LootRarity.Rare,

                "iMeds.PlasmaBagABN", LootRarity.Rare,
                "iMeds.PlasmaBagABN", LootRarity.Rare,
                "iMeds.PlasmaBagABN", LootRarity.Rare,
                "iMeds.PlasmaBagABP", LootRarity.Rare,
                "iMeds.PlasmaBagABP", LootRarity.Rare,
                "iMeds.PlasmaBagABP", LootRarity.Rare,
                "iMeds.PlasmaBagAN", LootRarity.Rare,
                "iMeds.PlasmaBagAN", LootRarity.Rare,
                "iMeds.PlasmaBagAN", LootRarity.Rare,
                "iMeds.PlasmaBagAP", LootRarity.Rare,
                "iMeds.PlasmaBagAP", LootRarity.Rare,
                "iMeds.PlasmaBagAP", LootRarity.Rare,
                "iMeds.PlasmaBagBN", LootRarity.Rare,
                "iMeds.PlasmaBagBN", LootRarity.Rare,
                "iMeds.PlasmaBagBN", LootRarity.Rare,
                "iMeds.PlasmaBagBP", LootRarity.Rare,
                "iMeds.PlasmaBagBP", LootRarity.Rare,
                "iMeds.PlasmaBagBP", LootRarity.Rare,
                "iMeds.PlasmaBagON", LootRarity.Rare,
                "iMeds.PlasmaBagON", LootRarity.Rare,
                "iMeds.PlasmaBagON", LootRarity.Rare,
                "iMeds.PlasmaBagOP", LootRarity.Rare,
                "iMeds.PlasmaBagOP", LootRarity.Rare,
                "iMeds.PlasmaBagOP", LootRarity.Rare,

                "iMeds.NasivionPack", LootRarity.Uncommon,
                "iMeds.NasivionPack", LootRarity.Uncommon,
                "iMeds.NasivionPack", LootRarity.Uncommon,
                "iMeds.NasivionPack", LootRarity.Uncommon,

                "iMeds.ErythropoietinPack", LootRarity.Rare,
                "iMeds.ErythropoietinPack", LootRarity.Rare,
                "iMeds.ErythropoietinPack", LootRarity.Rare,
                "iMeds.ErythropoietinPack", LootRarity.Rare,
            },
        },

        MedicalStorageTools = {
            items = {
                "iMeds.PeripheralVenousCatheter", LootRarity.Uncommon,
                "iMeds.PeripheralVenousCatheter", LootRarity.Uncommon,
                "iMeds.PeripheralVenousCatheter", LootRarity.Uncommon,
                "iMeds.PeripheralVenousCatheter", LootRarity.Uncommon,
                "iMeds.EmptyBloodBag", LootRarity.Uncommon,
                "iMeds.EmptyBloodBag", LootRarity.Uncommon,
                "iMeds.EmptyBloodBag", LootRarity.Uncommon,
                "iMeds.EmptyBloodBag", LootRarity.Uncommon,
                "iMeds.BloodTestingKit", LootRarity.Uncommon,
                "iMeds.BloodTestingKit", LootRarity.Uncommon,
                "iMeds.BloodTestingKit", LootRarity.Uncommon,
                "iMeds.BloodTestingKit", LootRarity.Uncommon,
                "iMeds.SyringePack", LootRarity.Uncommon,
                "iMeds.SyringePack", LootRarity.Uncommon,
                "iMeds.SyringePack", LootRarity.Uncommon,
                "iMeds.NeedlePack", LootRarity.Uncommon,
                "iMeds.NeedlePack", LootRarity.Uncommon,
                "iMeds.NeedlePack", LootRarity.Uncommon,

                "Base.BloodPressureMonitorLeft", LootRarity.Uncommon,
                "Base.BloodPressureMonitorLeft", LootRarity.Uncommon,
                "Base.BloodPressureMonitorLeft", LootRarity.ExtraRare,
                "Base.BloodPressureMonitorLeft", LootRarity.ExtraRare,

                "Base.HeartRateMonitorLeft", LootRarity.ExtraRare,
                "Base.HeartRateMonitorLeft", LootRarity.ExtraRare,
            },
        },

        StoreShelfMedical = {
            items = {
                "iMeds.BismuthSubsalicylatePack", LootRarity.Uncommon,
                "iMeds.BismuthSubsalicylatePack", LootRarity.Uncommon,
                "iMeds.AlkaginPack", LootRarity.Uncommon,
                "iMeds.AlkaginPack", LootRarity.Uncommon,
                "iMeds.UmifenovirPack", LootRarity.Uncommon,
                "iMeds.UmifenovirPack", LootRarity.Uncommon,
                "iMeds.UnknownPack", LootRarity.Uncommon,
                "iMeds.UnknownPack", LootRarity.Uncommon,
                "iMeds.ButamiratePack", LootRarity.Uncommon,
                "iMeds.ButamiratePack", LootRarity.Uncommon,
                "iMeds.BismuthSubsalicylatePack", LootRarity.Uncommon,
                "iMeds.BismuthSubsalicylatePack", LootRarity.Uncommon,
                "iMeds.HemoStopPack", LootRarity.Uncommon,
                "iMeds.HemoStopPack", LootRarity.Uncommon,
                "iMeds.SyringePack", LootRarity.Uncommon,
                "iMeds.SyringePack", LootRarity.Uncommon,
                "iMeds.NeedlePack", LootRarity.Uncommon,
                "iMeds.NeedlePack", LootRarity.Uncommon,
                "iMeds.NasivionPack", LootRarity.Uncommon,
                "iMeds.NasivionPack", LootRarity.Uncommon,

                "Base.BloodPressureMonitorLeft", LootRarity.Uncommon,
                "Base.BloodPressureMonitorLeft", LootRarity.Uncommon,
                "Base.BloodPressureMonitorLeft", LootRarity.ExtraRare,
                "Base.BloodPressureMonitorLeft", LootRarity.ExtraRare,

                "Base.HeartRateMonitorLeft", LootRarity.ExtraRare,
                "Base.HeartRateMonitorLeft", LootRarity.ExtraRare,
            },
        },
    }
}

for location, data in pairs(suburbsDistribution.all) do
    for _, value in ipairs(data.items) do
        table.insert(SuburbsDistributions['all'][location].items, value);
    end
end

for location, data in pairs(proceduralDistributions.list) do
    for _, value in ipairs(data.items) do
        table.insert(ProceduralDistributions['list'][location].items, value);
    end
end
